//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.17
//Title:Second law analysis of a control volume
//Determine rate of steam ﬂow into turbine
model Ex7_17

//===================
//parameter section
parameter Real P1(unit="bar")=8"Pressure at which the turbine receives steam";
parameter Real T(unit="deg C")=250"Temperature at which the turbine receives steam";
parameter Real P2(unit="bar")=1"Final Pressure";
parameter Real Ws(unit="MW")=20"Power output of the turbine";

//==================
//variable section
Real Xe(unit="dimensionless")"quality of the steam";
Real Si(unit="kJ/kg.K")"entropy for the reversible adiabatic process";
Real sg(unit="kJ/kg.K")"entropy at vapour state";
Real sf(unit="kJ/kg.K")"entropy at liquid state";
Real hg(unit="kJ/kg")"enthaly at vapour state";
Real hf(unit="kJ/kg")"enthalpy at liquid state";
Real m(unit="kg/s")"mass flow rate of the steam";
Real hi(unit="kJ/kg")"total enthalpy";
Real he(unit="kJ/kg")"enthalpy for calculating mass flow rate";

//================
//equation section
equation
//Refer to book Pg no:258 for the value of Se,sg,sf,hg,hf
Si=7.0248;
sg=7.3598;
sf=1.3027;
hi=2947.95;
hg=2675.4;
hf=417.54;
Si=(sg*Xe)+((1-Xe)*sf);
he=(Xe*hg)+((1-Xe)*hf);
he-hi=-((Ws*10^3)/m);//to calculate mass flow rate of steam
end Ex7_17;
