//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.19
//Title:Loss in available energy
//Determine the fraction of available energy lost 

model Ex7_19

//=================
//parameter section
parameter Real T1(unit="deg C")=500"Temperatre at which vapor is condensed";
parameter Real T2(unit="deg C")=250"Temperature at which it is voporised";
parameter Real TA(unit="deg C")=25"Ambient Temperature";

//==================
//variable section
Real Q(unit="kJ")"quantity of energy transferred as heat";
Real F(unit="dimensionless")"fraction of available energy lost due to irreversible process";

//================
//equation section
equation
Q=1;//value of Q is assumed to be 1 to solve the equation as the Q in numerator and denominator will get cancel
F=((TA+273)*((Q/(T2+273))-(Q/(T1+273))))/(Q*(1-((TA+273)/(T1+273))));
end Ex7_19;
