//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.21
//Title:Availability
//Estimate loss in availability in heat exchange process

model Ex7_21

//===================
//parameter section
parameter Real P1(unit="MPa")=0.1"Pressure of the steam entering";
parameter Real T1(unit="deg C")=150"Temperature at which steam enters";
parameter Real T2(unit="deg C")=40"steam at which steam leaves";
parameter Real T3(unit="deg C")=25"Temperature at which cold water enters";
parameter Real T4(unit="deg C")=35"Temperature at which cold water leaves";
parameter Real TA(unit="K")=300"Ambient temperature";
parameter Real M(unit="kg/h")=10000"rate of steam entering";

//=================
//variable section
Real h1(unit="kJ/kg")"enthalpy of steam entering";
Real h2(unit="kJ/kg")"enthalpy of steam leaving";
Real h3(unit="kJ/kg")"enthalpy of water entering";
Real h4(unit="kJ/kg")"enthalpy of water entering";
Real s1(unit="kJ/kg.K")"entropy of steam entering";
Real s2(unit="kJ/kg.K")"entropy of steam leaving";
Real s3(unit="kJ/kg.K")"entropy of water entering";
Real s4(unit="kJ/kg.K")"entropy of water leaving";
Real m3(unit="kg/h")"Flow rate of water";
Real NCA(unit="kJ")"Net change in avilability";
Real LA(unit="kJ")"loss in availability";

//===============
//equation section
equation
//Refer to steam table in appendix in book and refer to book Pg no:267 for the value of h1,h2,h3,h4,v1,v2,v3,v4
h1=2775.8;
s1=7.5984;
h2=167.45;
s2=0.5721;
h3=104.77;
s3=0.3670;
h4=146.56;
s4=0.5049;
(M*h1)+(m3*h3)=(M*h2)+(m3*h4);
NCA=-(M*TA*(s2-s1))-(m3*TA*(s4-s3));
LA=-NCA;
end Ex7_21;
