//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.5
//Title:Thermodynamic temperature scale
//Estimate fraction of time for which compressor runs for same cooling rate 
model Ex7_5

//===============
//parameter section
parameter Real TL(unit="deg C")=-23"Temperature to be maintained";
parameter Real TH1(unit="deg C")=18"Ambient Temperature in cold country";
parameter Real TH2(unit="deg C")=37"Ambient Temperature in tropical country";
parameter Real QL(unit="kJ/day")=4*10^4"cooling rate";
parameter Real CW(unit="W")=200"power of the compressor";

//===============
//variable section
Real COP1(unit="dimensionless")"coeficient of performance in first case";
Real COP2(unit="dimensionless")"coeficient of performance in second case";
Real W1(unit="kJ/day")"work on first condition";
Real W2(unit="kJ/day")"work on second condition";
Real CW1(unit="kJ/day")"compressor work in kJ/day";
Real FT1(unit="dimensionless")"fraction of time in firsst case";
Real FT2(unit="dimensionless")"fraction of time in second case";

//==================
//equation section
equation
COP1=(TL+273)/((TH1+273)-(TL+273));//Refer to book Pg no:234 for the equation
W1=QL/COP1;
CW1=(CW*3600*24)/1000;//multiplied by 3600*24 to convert sec to day
FT1=W1/CW1;
COP2=(TL+273)/((TH2+273)-(TL+273));
W2=QL/COP2;
FT2=W2/CW1;
end Ex7_5;
