//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004
  //Chapter 7:Second law of thermodynamics
  //Example:7.6
  //Title:Thermodynamic temperature scale
  //Determine 1energy removed as heat from cold body by referigerator and energy rejected to ambient atmosphere for each kJ of energy

package Ex7_6

model Ex7_6_a

//====================
//parameter section
parameter Real T1(unit="deg C")=150"Temperature of the source";
parameter Real TA(unit="deg C")=27"Ambient Temperature";
parameter Real TL(unit="deg C")=0"Temperature of the cold spce";

//==================
//variable section
Real E(unit="dimensionless")"energy removed as heat from the cold body by the refrigrator for each kJ of energy taken by the engine";

//===============
//equation section
equation
E=((TL+273)*(T1-TA))/((TA-TL)*(T1+273));//Refer tto book Pg no:235 for the equation
end Ex7_6_a;


//=================
model Ex7_6_b
extends Ex7_6_a;

//==================
//variable section
Real E1(unit="dimensionless")"energy rejected to the ambient temperature for each kJ of energy absorbed by the engine";

//=================
//equation section
equation
E1=((TA+273)*(T1-TL))/((TA-TL)*(T1+273));//Refer tto book Pg no:235 for the equation
end Ex7_6_b;

end Ex7_6;
