//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Thermodynamic Relations
//Example:8.10
//Title:Clapeyron equation
//Determine temperature at which water boils in pressure cooker
model Ex8_10

//=================
//parameter section
parameter Real P2(unit="kPa")=200"Pressure build up in the cooker";
parameter Real P1(unit="kPa")=101.325"latent heat of vaporization pressure";
parameter Real T1(unit="deg C")=100"latent heat of vaporiztion temperature";
parameter Real hfg(unit="kJ/kg")=2256.94"latent heat of vaporization";

//==================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//=================
//variable section
Real T2(unit="deg C")"final temperature";

//=================
//equation section
equation
log(P2/P1)=(hfg*18/R)*((1/(T1+273))-(1/(T2+273)));
end Ex8_10;
