//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Thermodynamic Relations
//Example:8.12
//Title:Kirchoff equation
//Calculate entropy change accompanying the process
model Ex8_12

//=================
//parameter section
parameter Real T1(unit="deg C")=-10"Temperature of the water";
parameter Real hsf(unit="kJ/kg")=334.92"latent heat of fusion at 0 deg C";
parameter Real T2(unit="deg C")=0"Temperature at whic latent heat of fusion is available";
parameter Real Cpf(unit="kJ/kg.K")=4.186"specific heat of liquid water";
parameter Real Cps(unit="kJ/kg.K")=2.093"specific heat of ice";

//=================
//variable section
Real hsfbyT(unit="kJ/kg.K")"latent heat of fusion by temperature";
Real delS(unit="kJ/kg.K")"change in entropy";

//==================
//equation section
equation
hsfbyT=(hsf/(T2+273.15))+((Cpf-Cps)*log((T1+273.15)/(T2+273.15)));//Refer to book Pg no:317 for the equation
delS=-hsfbyT;
end Ex8_12;
