//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Thermodynamic Relations
//Example:8.2
//Title:Thermodynamic Potentials
//Minimum amount of work required for compresion process if surroundings are at 300K
model Ex8_2

//===================
//parameter section
parameter Real T1(unit="K")=300"Temperature in the initial state";
parameter Real P1(unit="kPa")=100"Pressure in the initial state";
parameter Real T2(unit="K")=300"Temperature in the final state";
parameter Real P2(unit="Pa")=1"Pressur in the final state";
parameter Real Ts(unit="K")=300"Temperature in the surroundings";

//==================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//=================
//variable section
Real delS(unit="kJ/kmol.K")"change in entropy";
Real Wmin(unit="kJ/kmol.K")"minimum work required";
//================
//equation section
equation
delS=-R*log((P2*10^6)/(P1*10^3));
Wmin=-T1*delS;
end Ex8_2;
