//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004
//Chapter 9:Power and Refrigration cylcle
//Example:9.5
//Title:Air-standard otto cycle
//Determine compression ratio and thermal eﬃciency and net work
model Ex9_5

//====================
//parameter section
parameter Real P1(unit="kPa")=100"Pressure at the beginning of the compression stroke";
parameter Real T1(unit="deg C")=37"Temperature at the beginning of the compression stroke";
parameter Real P3(unit="MPa")=7"maximum pressure in the cycle";
parameter Real T3(unit="deg C")=2700"maximum temperture in the cycle";
parameter Real Cv(unit="kJ/kg.K")=0.7176"specific heat at constant volume";
parameter Real gamma(unit="dimensionless")=1.4"Ratio of specific heat";

//==================
//variable section
Real CR(unit="dimensionless")"compression ratio";
Real n(unit="dimensionless")"Thermal efficiency";
Real T2(unit="K")"final temperature of the cycle";
Real q1(unit="kJ/kg")"energy added as heat";
Real W(unit="kJ/kg")"net work";

//====================
//equation section
equation
CR=(P3*(T1+273.15))/((T3+273.15)*(P1/1000));//Refer to book Pg no:352 for the equation
n=1-((1/CR)^(gamma-1));
T2=(T1+273.15)*(CR^(gamma-1));
q1=Cv*((T3+273.15)-T2);
W=q1*n;
end Ex9_5;
