//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004
//Chapter 9:Power and Refrigration cylcle
//Example:9.8
//Title:Air-standard Brayton Cycle
//Determine 1temperature and pressure at each state of cycle 2compressor work 3turbine work per kg of air 4cycle eﬃciency

model Ex9_8

//===================
//parameter section
parameter Real T1(unit="K")=300"Temperature when the air the enters the compressor";
parameter Real P1(unit="kPa")=100"Pressure when the air the enters the compressor";
parameter Real Pr(unit="dimensionless")=8"Pressure Ratio";
parameter Real T3(unit="K")=1300"Maximum allowable Temperature";
parameter Real Cp(unit="kJ/kg.K")=1.0047"Specific heat at constant pressure";
parameter Real gamma(unit="dimensionless")=1.4"Ratio of specific heat";

//==================
//variable section
Real P2(unit="kPa")"Pressure when the air leaves the compressor";
Real T2(unit="K")"Temperature when the air leaves the compressor";
Real T4(unit="K")"Temperature when the air leaves the turbine";
//Real P4(unit="kPa")"Pressure when the air leaves the turbine";
Real Wc(unit="kJ/kg")"Word done on the compressor";
Real Wt(unit="kJ/kg")"Work done on the turbine";
Real NW(unit="kJ/kg")"Net work done";
Real q1(unit="kJ/kg")"energy added";
Real n(unit="dimensionless")"Thermal efficiency";

//==================
//equation section
equation

P2/P1=Pr;
T2=T1*(Pr^((gamma-1)/gamma));
T4=T3*((1/Pr)^((gamma-1)/gamma));
Wc=-Cp*(T2-T1);
Wt=Cp*(T3-T4);
NW=Wt+Wc;
q1=Cp*(T3-T2);
n=NW/q1;
end Ex9_8;
