//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 1:Introduction
//Example:1.1
//Title:units of measurements
//Determine force required to lift the bell jar off the plate
//=============================================================
model Ex1_1
extends Modelica.Constants;

//=============================================
//variable section

Real  F1(unit = "kN") "minimum pressure required to lift the bell jar of the plate";

//===========================
//parameter section


parameter Real P(unit = "Pa") = 25"pressure inside the jar that reduces due to the evacuvation with the help of vacuum pump";
parameter Real D(unit = "cm") = 50"diameter of jar";

//=======================
//equation section

 equation
 F1 =((101325-P) * (((D/100)^2)*pi/4)*0.001);      //force=pressure*area            // area=((pi*d*d)/4)   pi=3.14
                                            //101325-P is the net pressure acting on the bell jar
                                            //multiplied by 0.001 to conver to kN

end Ex1_1;                                
   
