//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 1:Introduction
//Example:1.3
//Title:units of measurements
//Determine final pressure of gas in cylinder
//==========================
model Ex1_3

//=======================
//variable section
 Real P(unit = "MPa") "final pressure";
 
//======================
//parameter section 

  parameter Real v(unit = "m^3") = 0.2"final volume of cylinder piston";
  parameter Real v0(unit = "m^3") = 0.1"initial volume of cylinder piston";
  parameter Real k(unit="kN/m")=50"spring constant";
  parameter Real a(unit="m^2")=0.05"area of the piston";
  
//==========================
//constant section  

  constant Real Pa(unit = "kPa") = 101.325"initial pressure in cylinder piston assembly";
  
  //===========
  //equation section
  
equation
 P=(Pa+(k*(v-v0))/(a^2))*0.001;   //force balance on piston  //refer page no 11
                          //multiplied by 0.001 to convert to MPa
end Ex1_3;
