//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 1:Introduction
//Example:1.5
//Title:units of measurements
//Express flow rate in terms of kmol per min
//====================
model Ex1_5

//======================
//variable section
 Real F(unit = "kmol/min") "flow rate";
 
//============================
//parameter section 
  parameter Real N1(unit = "mol") = 0.25"number of moles of nitrogen";
  parameter Real N2(unit = "mol") = 0.75"number of moles of hydrogen";
  parameter Real R(unit="kg/min")=100"rate at which the mixture enters into the reactor";
  
//======================
//constant section  
  constant Real M1(unit = "Kg/mol") =28*(0.001)"molecular wt of N2";
  constant Real M2(unit="Kg/mol")=2*(0.001)"molecular wt of H2";

//==============
//equation section

equation
F=(R/((N1*M1)+(N2*M2)))*0.001;       //flow rate=(rate in kg/min)/total weigtht of the mixture  //refer page no 12
                                     //multiplied by 0.001 to convert to kmol/min

end Ex1_5;
