//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.11
//Title:Air-Conditioning
//Determine volume of atmospheric air that can be mixed with cold air

model Ex10_11

//======================
//parameter section
parameter Real T2(unit="deg C")=25"Temperature of air to be supplied in the room";
parameter Real V1(unit="m^3/min")=10"flow rate of air from the desert cooler";
parameter Real T1(unit="deg C")=20"Temperature of air supplied from the desert cooler";
parameter Real si1(unit="%")=80"Relative humidity of air from the desert cooler";
parameter Real Ta(unit="deg C")=40"Atmospheric pressure";
parameter Real si2(unit="%")=20"Relative humidity of atmospheric air";

//======================
//variable section 
Real w1(unit="kg H2O/kg dry air")"specific humidity in the first case";
Real pw1(unit="kPa")"partial pressure of water vapor in the first case";
Real w2(unit="kg H2O/kg dry air")"specific humidity in the second case";
Real pw2(unit="kPa")"partial pressure of water vapor case";
Real w3(unit="kg H2O/kg dry air")"specific humidity in the third case";
Real Ra(unit="dimensionless")"ratio of ma1 and ma2";
Real V2(unit="m^3/min")"volume of water vapor that can be mixed with the water vapor";

//======================
//equation section
equation
//Refer to book Pg no:413 for the values of w1,w2,w3,pw1,pw2
w1=0.0118;
w2=0.009;
pw1=1.8;
pw2=1.3;
w3=0.011;//Refer to chart in book Pg no:413 for the value
Ra=(w2-w3)/(w3-w1);
V2=((101.325-pw1)*V1*(Ta+273.15))/(Ra*(101.325-pw2)*(T1+273.15));
end Ex10_11;
