//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.12
//Title:Air-Conditioning
//Determine the rates of heating and cooling required and calculate amount of water condensed in referigeration unit

model Ex10_12

//=========================
//parameter section
parameter Real P(unit="atm")=1"Pressure of moist air";
parameter Real si1(unit="%")=60"Relative humidity percent";
parameter Real T1(unit="deg C")=40"Temperature of air entering the dehumidifier";
parameter Real T2(unit="deg C")=20"Temperature of air leaving";
parameter Real si2(unit="%")=40"Relative humidity of air leaving";
parameter Real V1(unit="m^3/s")=1"flow rate of inlet air";

//========================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//========================
//variable section
Real w1(unit="kg H2O/kg dry air")"specific humidity when air entering the refrigration unit";
Real pw1(unit="kPa")"partial pressure of water vapor when air entering the refrigration unit";
Real h1(unit="kPa")"enthapy of air when air entering the refrigration unit";
Real ma1(unit="kg/kg dry air")"mass flow rate of air when air entering the refrigration unit";
Real w4(unit="kg H2O/kg dry air")"specific humidity when the air leaves the heating unit";
Real h4(unit="kg/kg dry air")"enthalpy when the air enters when the air leaves the heating unit";
Real si22(unit="dimensionless")"relative humidity when the air leaves as saturated air";
Real h2(unit="kJ/kg dry air")"enthalpy when the air leaves the saturated unit";
Real mw(unit="kg/s")"mass of water";
Real hw3(unit="kJ/kg")"enthalpy of water";
Real Qc(unit="kJ/s")"Refrigration capacity";
Real Q(unit="kJ/s")"rate of heating required";

//========================
//equation section
equation
//Refer to book Pg no:415 for the value of w1,pw1,w4,h4,si22,h2
//Refer to psychometric chart for the value of h1
w1=0.0284;
pw1=4.4;
h1=114;
ma1=((101.325-pw1)*V1*10^3*28.97)/(R*10^3*(T1+273.15));
w4=0.0056;
h4=34.5;
si22=1;
h2=20.5;
mw=ma1*(w1-w4);
hw3=25.21;
Qc=(ma1*(h1-h2))-(mw*hw3);
Q=ma1*(h4-h2);
end Ex10_12;
