//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.14
//Title:Air-Conditioning
//Estimate amount of water required to operate coler for 5 hours

model Ex10_14

//=======================
//parameter section
parameter Real Ta(unit="deg C")=49"Temperature of atmospheric air";
parameter Real rh(unit="%")=20"Relative humidity of atmospheric air";
parameter Real rh1(unit="%")=90"Relative humidity of the air coming out";
parameter Real V(unit="m^3/s")=1"volume ofair that the air can handle";
parameter Real t(unit="hours")=5"period of cooler operating";

//=======================
Real w1(unit="kg H2O/kg dry air")"specific humidity of the air entering";
Real w2(unit="kg H2O/kg dry air")"specific humidity of the air leaving";
Real mw(unit="kg/s")"mass of water required";
Real M(unit="kg")"mass of water required for 5 hours";

//========================
//equation section
equation
//Refer to book Pg no:430 for the value of w1,w2
w1=0.0147;
w2=0.023;
mw=V*(w2-w1);
M=mw*t*3600;
end Ex10_14; 
