//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.15
//Title:Cooling Towers
//Determine the makeup water required and air ﬂow rate

model Ex10_15

//======================
//parameter setion
parameter Real T(unit="deg C")=30"Temperature of cold water";
parameter Real T1(unit="deg C")=40"Temperature of water leaving the condenser";
parameter Real V(unit="kg/s")=1000"flow rate of water";
parameter Real si1(unit="dimensionless")=0.2"Relative humidity in the first case";
parameter Real T2(unit="deg C")=35"Temperature of air leaving the cooling tower";
parameter Real si2(unit="dimensionless")=0.8"Relative humidity of air leaving the cooling tower";
parameter Real Ta(unit="deg C")=40"Temperature of atmospheric air";

//=====================
//variable section
Real w1(unit="kg H2O/kg dry air")"specific humidity of water leaving the condenser";
Real h1(unit="kJ/kg dry air")"enthalpy of water leaving the condenser";
Real w2(unit="kg H2O/kg dry air")"specific humidity of water leaving the cooling tower";
Real h2(unit="kJ/kg dry air")"enthalpy of water leaving the condenser";
Real h3(unit="kJ/kg")"enthalpy of atmospheric air";
Real h4(unit="kJ/kg")"enthalpy of cold water";
Real ma(unit="kg/s")"flow rate of dry air";
Real mw(unit="kg/s")"make up water required";

//=====================
//equation section
equation
//Refer to book for the value of w1,h1,w2,h2
w1=0.009;
h1=64.5;
w2=0.029;
h2=109.5;
h3=167.45;//Refer to steam table in the appendix in the book Pg no:441 for the value of h3 and h4
h4=125.66;
ma=(V*(h3-h4))/((h2-h1)-((w2-w1)*h4));
mw=ma*(w2-w1);
end Ex10_15;
