//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.2
//Title:P-V-T Relationships for ideal gas mixtures
//Calculate partial pressure of constituents and express in mass fractions Also calculate ﬁnal pressure and composition

model Ex10_2

//======================
//parameter section
parameter Real N1(unit="%")=20"Amount of O2 in the gas";
parameter Real N2(unit="%")=50"Amount of N2 in the gas";
parameter Real N3(unit="%")=10"Amount of H2O in the gas";
parameter Real N4(unit="%")=20"Amount of CO2 in the gas";
parameter Real MW1(unit="kg/kmol")=32"Molecular weight of O2";
parameter Real MW2(unit="kg/kmol")=28"Molecular weight of N2";
parameter Real MW3(unit="kg/kmol")=18"Molecular weight of H2O";
parameter Real MW4(unit="kg/kmol")=44"Molecular weight of CO2";
parameter Real T(unit="K")=300"Temperature of the gas mixture";
parameter Real P(unit="kPa")=100"Pressure of the gas mixture";
 
//=====================
//variable section
Real p1(unit="kPa")"partial fraction of O2 in the first case";
Real p2(unit="kPa")"partial fraction of N2 in the first case";
Real p3(unit="kPa")"partial fraction of H2O in the first case";
Real p4(unit="kPa")"partial fraction of CO2 in the first case";
Real yO21(unit="dimensionless")"Mass freaction of O2 in the first case";
Real yN21(unit="dimensionless")"Mass freaction of N2 in the first case";
Real yH2O1(unit="dimensionless")"Mass freaction of H2O in the first case";
Real yCO21(unit="dimensionless")"Mass freaction of CO2 in the first case";
Real M1(unit="kg/kmol")"Molar mass of the mixture in the first case";
Real P2(unit="kPa")"final pressure";
Real yO22(unit="dimensionless")"Mole freaction of O2 in the second case";
Real yN22(unit="dimensionless")"Mole freaction of N2 in the second case";
Real yH2O2(unit="dimensionless")"Mole freaction of H2O in the second case";
Real M2(unit="kg/kmol")"molar mass of the mixture in the second case";
Real MF1(unit="dimensionless")"Mass fraction of O2";
Real MF2(unit="dimensionless")"Mas fraction of N2";
Real MF3(unit="dimensionless")"Mass fraction of H2O";
//Real x1,x2,x3,x4;
//=====================
//equation section
equation
p1=N1;
p2=N2;
p3=N3;
p4=N4;
//x1=N1*MW1/100;
M1=(N1*MW1/100)+(N2*MW2/100)+(N3*MW3/100)+(N4*MW4/100);//Refer to book Pg no:391 and 392
yO21=(N1*MW1/100)/M1;
yN21=(N2*MW2/100)/M1;
yH2O1=(N3*MW3/100)/M1;
yCO21=(N4*MW4/100)/M1;
P2=p1+p2+p3;
yO22=p1/P2;
yN22=p2/P2;
yH2O2=p3/P2;
M2=(yO22*MW1)+(yN22*MW2)+(yH2O2*MW3);
MF1=(yO22*MW1)/M2;
MF2=(yN22*MW2)/M2;
MF3=(yH2O2*MW3)/M2;
end Ex10_2;
