//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.5
//Title:Properties of ideal gas mixture
//Determine amount of methane to be added and ﬁnal pressure of mixture in tank

model Ex10_5

//====================
//parameter section
parameter Real V(unit="m^3")=5"Volume of the tank";
parameter Real N11(unit="%")=60"percentage of H2 in the tank in initial stage";
parameter Real N21(unit="%")=40"percentage of methane in the tank in initial stage";
parameter Real T(unit="K")=300"Temperature to be maintained";
parameter Real P(unit="kP")=100"Pressure of the tank";

//==================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//=================
//variable section
Real pH2(unit="kPa")"partial pressure of hydrogen in the first case";
Real pCH4(unit="kPa")"partial pressure of methane in the first case";
Real NH2(unit="kmol")"number of moles of hydrogen";
Real NCH4(unit="kmol")"number of moles of methane";
Real MA(unit="kmol")"number of moles of methane to be added";
Real Pf(unit="kPa")"final pressure";

//================
//equation section
equation
pH2=N11*P/100;//Refer to book Pg no:397 for the equation
pCH4=N21*P/100;
NH2=(pH2*1000*V)/(R*1000*T);
NCH4=(pCH4*1000*V)/(R*1000*T);
//after final composition
MA=NH2-NCH4;
Pf=((NH2+NH2)*R*1000*T)/(V*1000);
end Ex10_5;
