//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Gas-vapor mixtures and Psychometry
//Example:10.6
//Title:Properties of ideal gas mixture
//Determine 1ﬁnal temperature of gas mixture 2composition of mixture in tank 3amount of helium that enters tank

model Ex10_6

//=======================
//parameter section
parameter Real V(unit="m^3")=2"Volume of the tank";
parameter Real N1(unit="%")=50"percentage of air in the tank";
parameter Real N2(unit="%")=50"percentage of helium in the tank";
parameter Real P1(unit="kPa")=100"Pressure in the tank";
parameter Real T1(unit="K")=300"TEmperature in the tank";
parameter Real P2(unit="MPa")=4"Pressure in the valve";
parameter Real T2(unit="K")=600"Temperature in the valve";

//==================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//===============
//variable section
Real Ni(unit="kmol")"Total no. of moles";
Real Nair0(unit="kmol")"moles of air in the tank";
Real NHe0(unit="kmol")"moles of helium in the tank";
Real CvHe(unit="kJ/kmol.K")"specific heat of helium";
Real Cvair(unit="kJ/kmol.K")"specific heat of air";
Real U0(unit="kJ")"internal energy";
Real Cp(unit="kJ/kmol.K")"specific heat of the mixture";
Real NHef(unit="kmol",start=0)"final no. of moles of helium";
Real Tf(unit="K")"final temperature";
Real yHe(unit="dimensionless")"mole fraction of helium in final composition";
Real yair(unit="dimensionless")"mole fraction of air in final composition";
Real y(unit="kmol")"moles of helium that enters the tank";
Real x(unit="K.moles")"value of Pf*V/R";
Real a(unit="kJ.mol")"value of a in quadratic equation";
Real b(unit="kJ.mol")"value of b in quadratic equation";
Real c(unit="kJ.mol")"value of c in quadratic equation";
//=================
//equation section 
equation
Ni=(P1*1000*V)/(R*1000*T1);
Nair0=Ni*(N1/100);
NHe0=Ni*(N2/100);
//Refer to book Pg no:398 for the values of CvHe,Cvair,Cp
CvHe=12.4717;
Cvair=20.7889;
U0=((NHe0*CvHe)+(Nair0*Cvair))*T1;
Cp=20.786;
//(NHef-Nair0)*Cp*T2=(P2*10^6*V(NHefCvHe+NairCvair)/(NHe+Nair0))-U0
//which turns in to an quadratic equation
//NHef^2CpT2+(U0-xCvHe)NHef+(-Nair^2CpT-xNairCvair+U0Nair0)=0
x=(P2*10^6*V)/(R*10^3);
a=Cp*T2;
b=U0-(x*CvHe);
c=-(Nair0^2*Cp*T2)-(x*Nair0*Cvair)+(U0*Nair0);
NHef=(-b+sqrt((b^2)-(4*a*c)))/(2*a);//solving of quadratic equation
Tf=x/(NHef+Nair0);
yHe=NHef/(NHef+Nair0);
yair=Nair0/(NHef+Nair0);
y=NHef-Nair0;
end Ex10_6;
