//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.7
//Title:Ideal Gas-Vapor Mixtures
//Determine speciﬁc humidity and dew point and mass of water vapor and mass of dry air and partial pressure of water vapor and air
model Ex10_7

//=================
//parameter section
parameter Real rh(unit="%")=60"Relative humidity";
parameter Real P(unit="atm")=1"Pressure of the mixture";
parameter Real T(unit="deg C")=30"Temperature of the mixture";
parameter Real Pa(unit="kPa")=101.325"Total pressure in kPa";
parameter Real V(unit="m^3")=100"volume of the mixture";

//==================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//=================
//variable section
Real si1(unit="dimensionless")"Relative humidity";
Real Ps(unit="kPa")"saturation pressure";
Real pw(unit="kPa")"partial pressure of water vapor";
Real pa(unit="kPa")"partial pressure of water vapor";
Real w(unit="kg water /kg dry air")"specific humidity";
Real Mwv(unit="kg")"Mass of water vapor";
Real Mda(unit="kg")"Mass of dry air";
Real si2(unit="dimensionless")"Relative humidity when approaching 90%";
Real pw2(unit="kPa")"partial pressure of water vapor in the second case";
Real Ps2(unit="kPa")"saturation pressure in the second case";
//Real pw2(unit="kPa")"partial pressure of water vapor in the second case";

//=================
//equation section
equation
si1=rh/100;
//Refer to book Pg no:401 for the value of Ps
Ps=4.241;
si1=pw/Ps;
Pa=pw+pa;
w=0.622*(pw/pa);
Mwv=(pw*1000*V*18)/(R*1000*(T+273));
Mda=(pa*1000*V*28.97)/(R*1000*(T+273));
si2=0.9;
Ps2=8.2578;
si2=pw2/Ps2;
end Ex10_7;
