//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 2:Concepts and definitions
//Example:2.3
//Title:work
//Calculate work done by gas if volume is inversely proportional to pressure and if PV to power gamma is constant 
//===========

package Ex2_3
//==================
model Ex2_3_a
//=======================
//variable section
 Real W1(unit = "kJ") "work done when volume of gas is inversely proportional to pressure";
 //================================
 //parameter section
 
 parameter Real P1 (unit="kPa")=500 "initial pressure of the cylinder piston assembly";
 parameter Real P2(unit="kPa")=100 "final pressure of the cylinder piston assembly";
 parameter Real V1(unit="m^3")=0.2 "initial volume of the cylinder piston assembly";
 
 //==================
 //equation section
 
 equation
 W1=P1*V1*log(P1/P2);        //as (P1/P2)=(V2/V1)
                             //Work done=P1*V1*ln(V2/V1)  //refer page no 33
end Ex2_3_a;



//================================

model Ex2_3_b
extends Ex2_3_a;
//=======================
//variable section
 Real W2(unit="kJ")"work done when process follows the path pv^gamma";
 Real V2(unit="m^3")"final volume of piston cylinder";
 
 //====================
 //parameter section
 parameter Real ga=1.4  "heat capacity ratio";   //ga=gamma
 
 //=====================
 //equationn section
 equation
 V2=((P1*(V1^ga)/P2)^(1/ga));  //refer page no 34
 
 W2=((P2*V2)-(P1*V1))/(1-ga);  //work done in the path followed by the system PV^ga=const             
 end Ex2_3_b;


             
end Ex2_3;
