//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 2:Concepts and definitions
//Example:2.5
//Title:work
//Determine work done by gas in balloon 
//===================

model Ex2_5
extends Modelica.Constants;
//=================
//variable section

Real W(unit="kJ")"work done by the gas";
Real K(unit="kPa/(m^3)")"constant";        //P=K*(D^3)
Real D2(unit="m")"final diameter of the balloon";
//================
//parameter section

parameter Real D1( unit="m")=1"initial diameter of the balloon";
parameter Real P1( unit="kPa") =150 "initial pressure in which the gas is present";
parameter Real P2( unit="kPa") =450 "final pressure in which the gas is present";

//=============================
//equation section

equation
P1=K*(D1^3);             //as P is directly proportional to D^3  P=K*(D^3)
P2=K*(D2^3);
W=(pi*K*((D2^6)-(D1^6))/12);     //refef page no:36 for the equation
end Ex2_5;
