//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.1
//Title:Other equations of state
//Determine the volume of cylinder by ideas gas law and vander wals equation and Redlich Kwong equation .
//======================

package Ex3_1
//============================
model Ex3_1_a
//variable section
Real V1(unit="m^3")"volume of cylinder using ideal gas law";

//=========================
//parameter section

parameter Real T(unit="K")=300"temperature to store";
parameter Real P(unit="MPa")=60"pressure to be stored";

//==============
//constant section

constant Real R(unit="J/K mol")=8.314"gas constant";

//===================
//equation section

equation
V1=(1000*R*T)/(P*1000*1000);//ideal gas law
                            //multiplied pressure by 1000*1000 to convert MPa to Pa";
end Ex3_1_a;






//===================
model Ex3_1_b
extends Ex3_1_a;

//=================
//variable section

Real V2(unit="m^3")"volume of the cylinder using vander walls equation";
//============
//constant  section

constant Real a(unit="Pa(m^3/mol)^2")=228.296*(0.001)"constant value of a for methane";
constant Real b(unit="m^3/mol")=0.043*(0.001)"constant value of b for methane";
//=====================
//equation section

equation
((P*1000*1000)+(a/(V2^2)))*(V2-b)=R*T;//vander waals equation
end Ex3_1_b;
//Remarks:in Omedit simulation output window some debugs are shown because of the iteration in the vander waals equation
//



//=======================
model Ex3_1_c
extends Ex3_1_a;
//===============
//variable section
Real V3(unit="m^3/mol")"volume of the cylinder using Redlich Kwong eqn";
Real a(unit="m^6.Pa/mol^2");
Real b(unit="m^3/mol");
Real V3a(unit="m^3/kmol")"Volume of the cylinder using Redlich kwong eqn in m^3/kmol";
//=================
//parameter section
parameter Real Tc(unit="K")=190.70"critical temperature";
parameter Real Pc(unit="Pa")=46.41*100000"critical pressure";

//=================
//equation  section

equation
a=(0.42748*R*R*(Tc^2.5))/(Pc*(T^0.5));//Redlich Kwong equation value of a and b
b=(0.0867*R*Tc)/(Pc);                 //Refer to book for the equation Pg no:57
(P*1000*1000)=((R*T)/(V3-b))-(a/(V3*(V3+b)));//Redlich Kwong equation
V3a=V3*1000;//multiplied by 1000 to convert mol to kmol which is in the denominator
end Ex3_1_c;








end Ex3_1;
