//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.12
//Title:Tabular Representation of data
//Calculate speciﬁc volume enthalpy and internal energy
model Ex3_12

//==============
//parameter section
parameter Real X(unit="dimensionless")=0.85"quality of wet steam";
parameter Real P(unit="bar")=2"pressure of the steam";

//===========
//variabe section
Real hf(unit="kJ/kg")"specific enthalpy of the saturated liquid";
Real hg(unit="kJ/kg")"specific enthalpy of the saturated vapour";
Real vf(unit="kJ/kg")"specific volume of the saturated liquid";
Real vg(unit="kJ/kg")"specific volume of the saturated vapour";
Real h(unit="kJ/kg")"specific enthalpy of the mixture";
Real v(unit="kJ/kg")"specific volume of the mixture";
Real u(unit="kJ/kg")"specific internal energy";

//==================
//equation section
equation
//Refer to Appendix in book Pg no:443 for steam tables to find the value of hf,hg,vf,vg
vf=0.001060;//From book Pg no:443
vg=0.8854;
hf=504.70;
hg=2706.3;
v=(X*vg)+((1-X)*vf);//equation to find  specific volume of the mixture
h=(X*hg)+((1-X)*hf);//equation to find specific enthalpy of the mixture
u=((h*1000)-(P*(10^5)*v))/1000;////specific internal energy

end Ex3_12;
