//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.14
//Title:Tabular Representation of data
//Determine the state of steam
model Ex3_14

//==============
//parameter section
parameter Real P(unit="bar")=2"pressure of the steam";
parameter Real h(unit="kJ/kg")=2600"specific enthalpy of the steam";

//===========
//variable section
Real X(unit="dimensionless")"quality of wet steam";
Real hf(unit="kJ/kg")"specific enthalpy of the saturated liquid";
Real hg(unit="kJ/kg")"specific enthalpy of the saturated vapour";

//=============
//equation section
equation
//Refer to steam table in Appendix in Book Pg no:443 for the value of hf and hg
hf=504.70;
hg=2706.3;
h=(hg*X)+((1-X)*hf);//Refer to book Pg no:80 for the equation

//if the value of X is greater than 0.5 then the steam is wet else the steam is fully vapour
end Ex3_14;
