//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.15
//Title:Tabular Representation of data
//Estimate speciﬁc volume and speciﬁc enthalpy

model Ex3_15

//==================
//parameter section
parameter Real P(unit="bar")=25"pressure of the superheated steam";
parameter Real T(unit="deg C")=350"Temperature of the superheated steam";

//==============
//variable section

Real v(unit="m^3/kg")"specific volume at 25 bar and 350 deg C";
Real h(unit="kJ/kg")"specific enthalpy at 25 bar and 350 deg C";
Real P1(unit="bar")"Pressure less than 25 bar in steam table ie.24 bar";
Real P2(unit="bar")"Pressure greater than 25 bar in steam table ie. 26 bar";
Real T1(unit="deg C")"Temperature less than 350 deg C in steam table ie.300 deg C";
Real T2(unit="deg C")"Temperature greater than 350 deg C in steam table ie. 400 deg C";
Real v1(unit="m^3/kg")"specific volume at 24 bar 300 deg C";
Real v2(unit="m^3/kg")"specific volume at 26 bar 300 deg C";
Real v3(unit="m^3/kg")"specific volume at 24 bar 400 deg C";
Real v4(unit="m^3/kg")"specific volume at 26 bar 400 deg C";
Real h1(unit="kJ/kg")"specific enthalpy at 24 bar 300 deg C";
Real h2(unit="kJ/kg")"specific enthalpy at 26 bar 300 deg C";
Real h3(unit="kJ/kg")"specific enthalpy at 24 bar 400 deg C";
Real h4(unit="kJ/kg")"specific enthalpy at 26 bar 400 deg C";
Real v5(unit="m^3/kg")"specific volume at 25 bar 300 deg C";
Real v6(unit="m^3/kg")"specific volume at 25 bar 400 deg C";
Real h5(unit="kJ/kg")"specific enthalpy at 25 bar 300 deg C";
Real h6(unit="kJ/kg")"specific enthalpy at 25 bar 400 deg C";

//===================
//equation section
equation
//Refer to Appendix c in Book Pg no:447 for the values of v1,v2,v3,v4,h1,h2,h3,h4
P1=24;
P2=26;
T1=300;
T2=400;
v1=0.10336;//also Refer to book Pg no:81 for easy reference of v1,v2,v3,v4,h1,h2,h3,h4
v2=0.09483;
v3=0.12522;
v4=0.11526;
h1=3013.4;
h2=3007.4;
h3=3242.3;
h4=3239.0;
(v5-v1)/(v1-v2)=(P-P1)/(P1-P2);//Equation for interpolation and finding the values Refer to previous examples in book for the formula
(v6-v3)/(v3-v4)=(P-P1)/(P1-P2);
(h5-h1)/(h1-h2)=(P-P1)/(P1-P2);
(h6-h3)/(h3-h4)=(P-P1)/(P1-P2);
(v-v5)/(v5-v6)=(T-T1)/(T1-T2);//final value of specific volume at 25 bar and 350 deg C
(h-h5)/(h5-h6)=(T-T1)/(T1-T2);//final value of specific enthalpy at 25 bar and 350 deg C
end Ex3_15;
