//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.17
//Title:Tabular Representation of data
//Determine proportions by volume of liquid and vapor

model Ex3_17

//============
//parameter section

parameter Real P(unit="kPa")=100"pressure at which the mixture is stored in the vessel";

//============
//variable section

Real vc(unit="m^3/kg")"critical state volume";
Real vf(unit="m^3/kg")"specific volume in liquid state";
Real vg(unit="m^3/kg")"specific volume in vapour state";
Real Vl(unit="m^3")"Volume of liquid";
Real Vv(unit="m^3")"volume of vapour";
Real R(unit="dimensionless")"Ratio of liquid to vapour by volume";
Real X(unit="dimensionless")"quality of wet steam";
//=================
//equation section 
equation
//Refer to book Pg no:82 for the value of vc
//Refer to book Appendix Pg no:443 for the value of vf and vg
vc=0.00317;
vf=0.0010434;
vg=1.694;
vc=(X*vg)+((1-X)*vf);//Refer to book Pg no:82
Vl=(1-X)*vf;
Vv=X*vg;
R=((1-X)*vf)/(X*vg);
end Ex3_17;
