//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.5
//Title:Compressibility Chart
//Rework previous example using pseudo reduced volume

model Ex3_5

//===========================
//parameter setion

parameter Real Tc(unit="K")=405.5"temperature";
parameter Real Pc(unit="bar")=112.17"pressure";
parameter Real R(unit="J/K.mol")=8.314"gas constant";
parameter Real T(unit="deg C")=200"temperature";
parameter Real V(unit="m^3")=0.1"volume of vessel";
parameter Real Pr(unit="dimensionless")=1.9"reduced pressure";   //refer to book pg no:63 for finding Pr from graph
//======================
//variable section
Real Tr(unit="dimensionless")"reduced pressure";
Real vr(unit="dimensionless");
Real P(unit="MPa")"pressure exerted by ammonia";

//=====================
//equation section
equation
Tr=(T+273)/Tc;
vr=(112.77*100000*(0.1/1000))/(8.314*405.5);//Refer to book Pg no:63 and graph in Pg no:64 to find the value of Pr from graph at the intersection of Tr and vr

P=Pr*(Pc*100000)/1000000;
end Ex3_5;
