//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.1
//Title:First law analysis of elementary process
//Determine temperature of steam and quality of steam and masses of liquid in ﬁnal state
package Ex5_1

model Ex5_1_a

//======================
//parameter section
parameter Real V(unit="m^3")=0.1"volume of the radiator";
parameter Real P1(unit="MPa")=0.2"Pressure at which the saturated steam exists";
parameter Real P2(unit="MPa")=0.15"Pressure drop due to energy transfer";

//===========
//variable section
Real v1(unit="m^3")"specific volume of the saturated steam at the initial pressure";
Real m(unit="kg")"Total mass of the steam";
Real T2(unit="deg C")"Temperature in the final state";

//=========
//equation section
equation
v1=0.8854;//Refer to the graph in book Pg no:107 and find the value of v1
m=V/v1;
T2=111.37;//Refer to steam table in appendix in book Pg no:443 and find the value of the temperature

end Ex5_1_a;

//=====================

model Ex5_1_b
extends Ex5_1_a;

//===================
//variable section

Real vf(unit="m^3/kg")"specific volume in liquid state";
Real vg(unit="m^3/kg")"specific volume in vapour state";
Real X2(unit="dimensionless")"quality of the steam in the final state";
Real v2(unit="m^3")"specific volume of the saturated steam at the final state";

//===============
//equation section
equation
//Refer to steam table in appendix in book Pg no:443 and find the value of the vf and vg
vf=0.001053;
vg=1.159;
v2=v1;//As the quantity of the steam and the volume of the radiator are constant so the steam undergoes constant volume process Refer to book Pg no:108
v2=(X2*vg)+((1-X2)*vf);//equation for calculation of X2
end Ex5_1_b;



//===================

model Ex5_1_c
extends Ex5_1_a;
extends Ex5_1_b;

//============
//variable section

Real Mv(unit="Kg")"Mass of vapour";
Real Ml(unit="kg")"Mass of liquid";

//===========
//equation section

equation
Mv=X2*m;//Refer to book Pg no:108 equation for calculation of mass of vapour
Ml=m-Mv;//equation for calculation of mass of liquid
end Ex5_1_c;

end Ex5_1;
