//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.10
//Title:Polytropic process
//Determine pressure temperature at end of compression Work done on gas and energy transfer of heat per mole of air
package Ex5_10

model Ex5_10_a

//===============
//parameter section
parameter Real P1(unit="kPa")=100"initial pressure of the air";
parameter Real T1(unit="deg C")=27"initial temperature of the air";
parameter Real V2(unit="dimensionless")=1/16"ratio of final volume to initial volume";
parameter Real gamma(unit="dimensionless")=1.25"ratio of specific heat";

//===============
//variable section
Real P2(unit="MPa")"final pressure of the air";
Real T2(unit="K")"final temperature of the air";

//==============
//equation section
equation
P2=(P1*(1/V2)^gamma)/1000;//divided by 1000 to convert kPa to MPa
T2=((T1+273)*V2*P2*10^6)/(P1*1000);
end Ex5_10_a;



//===================
model Ex5_10_b
extends Ex5_10_a;

//=================
//variable section
Real W(unit="kJ/mol")"work done on the gas";

//=======================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//======================
//equation section
equation
W=R*((T1+273)-T2)/((gamma-1)*1000);//work done on the gas
end Ex5_10_b;

//==================

model Ex5_10_c
extends Ex5_10_a;
extends Ex5_10_b;

//====================
//parameter section
parameter Real gamma1(unit="dimensionless")=1.4"ratio of specific heat";
//================
//varable section
Real q(unit="kJ/mol")"energy transfer as heat";

//============
    //equation section
  equation
q=((R*(T2-(T1+273))/(gamma1-1))+(W*1000))/1000;//Refer to book Pg:123 for the equation
end Ex5_10_c;


end Ex5_10;
