//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.11
//Title:constant internal energy process
//Determine pressure and temperature after equilibrium
model Ex5_11

//=====================
//parameter section 
parameter Real V(unit="m^3")=2"volume of the container";
parameter Real P1(unit="kPa")=200"pressure in which the helium is kept";
parameter Real T1(unit="deg C")=127"Temperature in which the helium is kept";
parameter Real P2(unit="kPa")=400"pressure in which the nitrogen is kept";
parameter Real T2(unit="deg C")=227"Temperaturee in which the helium is kept";

//===========
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//======================
//variable section
Real CvHe(unit="J/mol.K")"specific heat of helium";
Real CvN2(unit="J/mol.K")"specific heat of nitrogen";
Real NHe(unit="mol")"number of moles of helium";
Real NN2(unit="mol")"number of moles of nitrogen";
Real Tf(unit="K")"final temperature";
Real V1(unit="m^3")"volume of the compartment in which helium is held";
Real V2(unit="m^3")"volume of the compartment in which nitrogen is held";
Real Pf(unit="kPa")"final pressure";

//========================
//equation section
equation
V1=(V/2);//First compartment volume is equal to second compartent volume so V1=V/2
V2=(V/2);
CvHe=3*R/2;
CvN2=5*R/2;
NHe=(P1*1000*V1)/(R*(T1+273));
NN2=(P2*1000*V2)/(R*(T2+273));
(NHe*CvHe*(Tf-(T1+273)))+(NN2*CvN2*(Tf-(T2+273)))=0;
Pf*V=(NHe+NN2)*R*Tf/1000;
end Ex5_11;
