//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.12
//Title:constant internal energy process
//Determine ﬁnal temperature and pressue of water in tank
model Ex5_12

//=====================
//parameter section
parameter Real V(unit="m^3")=1"volume of the container";
parameter Real V1(unit="m^3")=0.05"volume of the first cmpartment";
parameter Real T1(unit="deg C")=170"Temperature of the first cmpartment";
parameter Real P1(unit="MPa")=1"Pressure of the first cmpartment";

//===================
//variable section
Real v1(unit="m^3/kg")"specific volume  at the saturated condition";
Real h1(unit="kJ/kg")"specific enthalpy at the saturated condition";
Real u1(unit="kJ/kg")"internal energy at the initial condition";
Real Ml(unit="kg")"Mass of liquid";
Real vf(unit="m^3/kg")"specific volume in the second state";
Real hf(unit="kJ/kg")"specific enthalpy in liquid state";
Real vg(unit="m^3/kg")"specific volume in vapour state";
Real hg(unit="kJ/kg")"specific enthalpy in vapour state";
Real X2(unit="dimensionless")"quality of the steam";
Real h2(unit="kJ/kg")"specific enthalpy at the final condition";
Real u2(unit="kJ/kg")"internal energy at the final condition";
output Real P2(unit="bar")"final pressure of the container";
Real v2(unit="m^3/kg")"final specific volume";
output Real T2(unit="deg C")"final temperature";

//==============
//equation section
equation
//Refer to steam table in appendix in book Pg no:446
v1=0.0011145;
h1=719.12;
Ml=V1/v1;
u1=h1-(P1*1000*v1);
v2=V/Ml;
P2=4.5;//Refer to book Pg no:127 for the assumptions of P2
T2=147.73;
//Refer to steam table in appendix Pg no:441 and then find the value of vf,vg,hf,hg for 145 and 150 deg C and then interpolate for 147.73 deg C
vf=1.088*10^(-3);
hf=622.4;
vg=0.4185;
hg=2742.55;
v2=(X2*vg)+((1-X2)*vf);
h2=(X2*hg)+((1-X2)*hf);
u2=((h2*1000)-(P2*10^5*v2))/1000;


end Ex5_12;
