//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.14
//Title:constant internal energy process
//Determine steam temperature in cylinder and energy transfer as heat
package Ex5_14

model Ex5_14_a
//=======
//parameter section
parameter Real M(unit="kg")=0.1"mass of saturated steam in the cylinder";
parameter Real P1(unit="bar")=2"initial pressure of the steam";
parameter Real K(unit="kN/m^2")=250"value of spring constant";
parameter Real A(unit="m^2")=0.05"cross sectional area of the piston";
parameter Real P2(unit="bar")=4"final pressure of the steam";
parameter Real Pa(unit="bar")=1"atmospheric pressure";

//==============
//variable section
Real V1(unit="m^3/kg")"specific volume in the vapour state or volume of steam when P=P1";
Real V0(unit="m^3")"volume corresponding to the unstretched spring";
Real V2(unit="m^3")"volume corresponding to the final state";
Real T(unit="deg C")"final temperature of the steam";
Real Ta1(unit="deg C")"temperature just above the final temperature in steam table";
Real Ta2(unit="deg C")"temperature just below the final temperature in steam table";
Real Va1(unit="m^3/kg")"specific volume just above the final volume";
Real Va2(unit="m^3/kg")"specific volume just below the final volume";
//Real v2(unit="m^3/kg")"final volume in terms of m^3/kg";
//================
//equation section
equation
//Refer to steam table in the appendix in the book Pg no:443 for 2 bar and get the value of V0
V1=0.8854;
P1*10^5=(Pa*10^5)+(K*1000*((V1*M)-V0)/(A^2));//Refer to book Pg no:130 for the equation
P2*10^5=(Pa*10^5)+(K*1000*(V2-V0)/(A^2));
//get the value of V2 and from the steam table in the appendix book Pg no:446 we get value of Va1 at 500 C and Va2 at 600 C
Ta1=500;
Ta2=600;
Va1=0.8892;
Va2=1.0054;
(T-Ta1)/(Ta2-Ta1)=((V2/M)-Va1)/(Va2-Va1);
end Ex5_14_a;


//==================

model Ex5_14_b
extends Ex5_14_a;

//=================
//variable section
Real h1(unit="kJ/kg")"enthalpy at 4 bar and 513.94 deg C";
Real h2(unit="kJ/kg")"enthalpy at 2 bar";
Real W(unit="kJ")"work done";
Real delU(unit="kJ/kg")"change in internal energy";
Real Q(unit="kJ")"energy transfer as heat";
Real u1(unit="kJ/kg")"internal energy in first case";
Real u2(unit="kJ/kg")"internal energy in second case";
//======================
//equation section
equation
//Refer to steam table in the appendix in book for the value of h2 and h1
h2=3515.2;
h1=2706.3;
u2=((h2*1000)-(P2*10^5*(V2/M)))/1000;//Refer to book Pg no:130 for equation
u1=((h1*1000)-(P1*10^5*V1))/1000;
W=(((P1+P2)/2)*10^5*(V2-(V1*M)))/1000;//divided by 1000 to convert J to kJ
delU=(u2-u1);
Q=(delU*M)+W;
end Ex5_14_b;






end Ex5_14;
