//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.2
//Title:First law analysis of elementary process
//Determine work done on helium and ﬁnal pressure

model Ex5_2

//=================
//parameter section
parameter Real V1(unit="m^3")=1"volume of the cylinder";
parameter Real T1(unit="deg C")=20"initial temperature of the helium";
parameter Real T2(unit="deg C")=60"final temperature of the helium";
parameter Real P1(unit="kPa")=100"initial pressure of the cylinder";
parameter Real Cv(unit="kJ/kmol.K")=12.4717"value of specific heat given in book";
//==========
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//===============
//variable section
Real N(unit="kmol")"number of moles of helium";
Real delU(unit="kJ")"change in internal energy";
Real W(unit="kJ")"work done";
Real P2(unit="kPa")"final pressure of helium";

//=============
//equation section
equation
N=((P1*V1*1000)/(R*1000*(T1+273.15)));//Refer to book Pg no:108 for the equation
delU=N*Cv*(T2-T1);
W=-delU;
P2=(P1*1000*(T2+273.15))/((T1+273.15)*1000);
//Remarks:Actual value of T2 is 60 which is given in the question and using that we get P2=113.645 but for solving the answer in book T2 is taken as 40 deg C which is error.
end Ex5_2;
