//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.5
//Title:First law analysis of elementary process
//Calculate work done by steam and energy transferred as heat
package Ex5_5

model Ex5_5_a

//===========
//parameter section
parameter Real X1(unit="dimensionless")=0.75"quality of steam";
parameter Real P(unit="bar")=5"pressure in which the steam is contained";
parameter Real T(unit="deg C")=200"pressure the steam attains";

//================
//variable section
Real v1(unit="m^3/kg")"initial volume";
Real vf(unit="m^3/kg")"specific volume in liquid state";
Real vg(unit="m^3/kg")"specific volume in vapour state";
Real v2(unit="m^3/kg")"final volume";
Real W(unit="kJ/kg")"work done by the steam";

//===============
//equation section
equation
//Refer to steam table in appendix in book Pg no:443 for the values of vf and vg
vf=0.0010928;
vg=0.3747;
v1=(X1*vg)+((1-X1)*vf);
//Refer to steam table in appendix in book Pg no:446 for the value of v2
v2=0.425;
W=P*(10^5)*(v2-v1)/1000;
//Remarks:value of W is 71.85 but in book given as 72.35 which is error less than 5%
end Ex5_5_a;


//=======================

model Ex5_5_b
extends Ex5_5_a;

//================
//variable section
Real h1(unit="kJ/kg")"initial enthalpy of steam";
Real hf(unit="kJ/kg")"specific enthalpy in liquid state";
Real hg(unit="kJ/kg")"specific enthalpy in vapour state";
Real h2(unit="kJ/kg")"final enthalpy";
Real q(unit="kJ/kg")"energy transferred as heat";

//===============
//equation section
equation
//Refer to steam table in appendix in book Pg no:443 for the values of hf and hg
hf=640.12;
hg=2747.5;
h1=(X1*hg)+((1-X1)*hf);
//Refer to steam table in appendix in book Pg no:446 for the value of v2
h2=2855.1;
q=h2-h1;

end Ex5_5_b;


end Ex5_5;
