//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.7
//Title:Adiabatic process
//Calculate ﬁnal temperature,compression ratio and work done per mole of fuel air mixture
model Ex5_7

//================
//parameter section
parameter Real P1(unit="kPa")=100"initial pressure of the air fuel mixture";
parameter Real T1(unit="K")=300"initial temperature of the air fuel mixture";
parameter Real P2(unit="MPa")=2"final pressure of the air fuel mixture";
parameter Real gamma(unit="dimensionless")=1.4"ratio of specific heat";

//===========
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//============
//variable section
Real T2(unit="K")"final temperature of the air fuel mixture";
Real CR(unit="dimensionless")"compression ratio which is defined as ratio of initial volume to final volume";
Real W(unit="kJ/mol")"work done of the fuel air mixture";

//==============
//equation section
equation
T2=T1*(((P2*10^6)/(P1*1000))^((gamma-1)/gamma));//reafer to book Pg no:120 for the equation
CR=(P2*10^6*T1)/(P1*1000*T2);
W=(R*(T1-T2))/((gamma-1)*1000);//divided by 1000 to convert J to kJ
end Ex5_7;
