//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.9
//Title:Adiabatic process
//Determine work done on gas and change in internal energy and ﬁnal temperature
model Ex5_9

//==============
//parameter section
parameter Real gamma(unit="dimensionless")=1.4"ratio of specific heats";
parameter Real P1(unit="kPa")=100"initial pressure of the gas";
parameter Real P2(unit="MPa")=1"final pressure of the gas";
parameter Real T1(unit="deg C")=27"initial temperature of the gas";

//===========
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//===============
//variable section
Real T2(unit="K")"final temperature of the gas";
Real W(unit="kJ")"work done on the gas";
Real delU(unit="kJ")"change in internal energy";

//===============
//equation section
equation
T2=(T1+273)*(((P2*10^6)/(P1*1000))^((gamma-1)/gamma));//Refer to book Pg no:121 for the equation
W=R*((T1+273)-T2)/((gamma-1)*1000);
delU=-W;
//Remarks:In book the solution for the question above is solved correctly till work done =-5803.2J/mol but when converter to kJ work done should be divided by 1000 but it is divided by 100 and given as -58.032kJ which is error original answer is -5.8032
end Ex5_9;
