//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:case of an ideal gas
//Example:6.11
//Determine temperature of air left in cylinder and mass of air escsaped from cylinder

model Ex6_11

//===================
//parameter section
parameter Real V(unit="m^3")=0.1"volume of gas cylinder";
parameter Real P0(unit="bar")=50"initial pressure of the cylinder";
parameter Real T0(unit="K")=300"initial temperature of the cylinder";
parameter Real Pf(unit="bar")=30"final pressure of the cylinder";
parameter Real gamma(unit="dimensionless")=1.4"Ratio of specific heat for ideal gas";
parameter Real M(unit="kg")=28.97"molar mass of air";

//================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//========================
//variable section
Real Tf(unit="K")"final temperature of the cylinder";
Real m0(unit="kg")"initial mass of air";
Real mf(unit="kg")"final mass of air";
Real delM(unit="kg")"mass of air that escapes from cylinder";

//===================
//equation section
equation
Tf=((Pf/P0)^((gamma-1)/gamma))*T0;//equation to finf Tf Refer to book Pg no:173
m0=(M*10^(-3)*P0*10^5*V)/(R*T0);
mf=(M*10^(-3)*Pf*10^5*V)/(R*Tf);
delM=m0-mf;
end Ex6_11;
