//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:case of an ideal gas
//Example:6.12
//Title:Case of an ideal gas
//Estimate ﬁnal pressure in the tank
model Ex6_12

//===================
//parameter section
parameter Real M1(unit="kg")=1000"Mass of wet steam";
parameter Real P1(unit="bar")=30"Pressure of wet steam";
parameter Real VL(unit="%")=50"amount of liquid that the tank contains";
parameter Real VV(unit="%")=50"amount of vapor that the tank contains";
parameter Real M2(unit="kg")=100"weight of moisture free air";

//==================
//variable section
Real V(unit="m^3")"Volume of the tank";
Real mf(unit="kg")"mass of liquid";
Real mg(unit="m^3")"mass of vapor";
Real vf(unit="m^3/kg")"specific volume of the liquid";
Real vg(unit="m^3/kg")"speciic volume of the vapor";
Real X1(unit="dimensionless")"quality of the steam in the first confdition";
Real hf(unit="kJ/kg")"enthalpy in liquid state for first condition";
Real hg(unit="kJ/kg")"enthalpy in vapor state for first condition";
Real h1(unit="kJ/kg")"Total enthalpy in the first condition";
Real u1(unit="kJ/kg")"internal energy in the first condition";
Real v2(unit="m^3/kg")"final specific volume";
Real vg1(unit="m^3/kg")"specific volume in vapor state for the first condition";
Real vf1(unit="m^3/kg")"specific volume in liquid state for the first condition";
Real X2(unit="dimensionless")"quality of the steam in the second condition";
Real hg1(unit="kJ/kg")"enthalpy in vapor state for the second condition";
Real hf1(unit="kJ/kg")"enthalpy in liquid state for the second condition";
Real h2(unit="kJ/kg")"Total enthalpy in the second condition";
Real u2(unit="kJ/kg")"internal energy in the second condition";
Real hg2(unit="kJ/kg")"enthalpy for the given equation";
Real hf2(unit="kJ/kg")"enthalpy for the given equation";
Real vg2(unit="m^3/kg")"specific volume in vapor state for the second condition";
Real vf2(unit="m^3/kg")"specific volume in liquid state for the second condition";
Real X3(unit="dimensionless")"quality of the steam in the third condition";
Real h3(unit="kJ/kg")"final enthalpy in the second condition";
Real u3(unit="kJ/kg")"final internal energy in the second condition";
Real hg3(unit="kJ/kg")"enthalpy in the vapor state for the third condition";
Real hf3(unit="kJ/kg")"enthalpy in the liquid state for the third condition";
Real vg3(unit="m^3/kg")"specific volume in vapor state for the third condition";
Real vf3(unit="m^3/kg")"specific volume in liquid state for the third condition";
Real X4(unit="dimensionless")"quality of the steam in the fourth condition";
Real h4(unit="kJ/kg")"enthalpy of the steam in the third condition";
Real u4(unit="kJ/kg")"internal energy of the steam in the third condition";

//================
//equation section
equation
//Refer to book Pg no:174 for the values f vf,vg,hf,hg
vf=0.0012163;
vg=0.06663;
M1=(V/2)*((1/vf)+(1/vg));
V/2=mf*vf;
V/2=mg*vg;
X1=mg/1000;
hg=2802.3;
hf=1008.4;
h1=(X1*hg)+((1-X1)*hf);
u1=((h1*1000)-(P1*10^5*V/1000))/1000;
v2=V/(1000-M2);
vg1=0.1317;
vf1=0.0011539;
v2=(X2*vg1)+((1-X2)*vf1);
hg1=2789.8;
hf1=844.67;
h2=(X2*hg1)+((1-X2)*hf1);
u2=((h2*1000)-((P1/2)*10^5*v2))/1000;
hg2=2787.8;
vg2=0.1407;
vf2=0.0011489;
v2=(X3*vg2)+((1-X2)*vf2);
hf2=830.08;
h3=(X3*hg2)+((1-X3)*hf2);
u3=((h3*10^3)-(14*10^5*v2))/1000;
hg3=2787.32;
hf3=827;
vf3=1.1478*10^(-3);
vg3=0.1428;
v2=(X4*vg3)+((1-X4)*vf3);
h4=(X4*hg3)+((1-X4)*hf3);
u4=((h4*10^3)-(13.8*10^5*v2))/1000;
//Remarks:in book for calculation  of the first internal energy Pressure is taken as 3 bar which is error
end Ex6_12;
