//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:chemically reacting systems
//Example:6.16
//Determine composition of fuel on mass basis and air fuel ratio on mass basis and percent excess or deﬁcit air
package Ex6_16

model Ex6_16_a

//=====================
//parameter section
parameter Real CO2(unit="%")=9.27"% of CO2 in resulting flue gas";
parameter Real CO(unit="%")=2.31"% of CO in resulting flue gas";
parameter Real O2(unit="%")=4.86"% of O2 in resulting flue gas";
parameter Real N2(unit="%")=83.56"% of N2 in resulting flue gas";
parameter Real MC(unit="kg/mol")=12"molar mass of carbon";

//CxHy+zO2+3.7619zN2----------->9.27CO2+2.31CO+aH2+4.86O2+83.56N2 refer to equation in book Pg no:179
//==================
//variable section
Real z(unit="dimensionless")"value to balance nitrogen";
Real x(unit="dimensionless")"value to balance carbon";
Real y(unit="dimensionless")"value to balance hydrogen";
Real a(unit="dimensionless")"value to balance carbon";
Real CC(unit="%")"composistion of carbon";
Real CH(unit="%")"composition of hydrogen";

//====================
//equation section
equation 
3.7619*z=N2;
x=CO2+CO;
z=9.27+(2.31/2)+(a/2)+4.86;//values taken from the stoichiometry equation
y=2*a;
CC=((x*MC)/((x*MC)+y))*100;
CH=(y/((x*MC)+y))*100;

end Ex6_16_a;


//===========================
model Ex6_16_b
extends Ex6_16_a;

//========================
    //parameter section
    parameter Real MA(unit="kg/mol")=28.97"molar mass of air";
//=================
//variable section
Real AFR(unit="kg air/kg fuel")"air fuel ratio";

//===================
//equation section
equation
AFR=((z+N2)*MA/((x*MC)+y));//refer to book Pg no:180
end Ex6_16_b;



//========================
model Ex6_16_c
extends Ex6_16_a;
extends Ex6_16_b;

//C11.58H27.7+25.423O2+25.43*3.7619N2---------->11.58CO2+13.85H2O+95.665N2

//================
//variable section
Real NO2(unit="moles")"coefficient of O2";
Real NN2(unit="moles")"coefficient of N2";
Real TR(unit="kg air/kg fuel")"theoratical air fuel ratio";
Real PTA(unit="%")"percent theoratical air";
Real DA(unit="%")"percent deficit air";

//======================
//equation section
equation
NO2=25.43;//coefficient taken from stoichimetry equation
NN2=95.665;
TR=(NO2+NN2)*MA/((x*MC)+y);
PTA=(AFR/TR)*100;
DA=100-PTA;
end Ex6_16_c;
end Ex6_16;
