//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:chemically reacting systems
//Example:6.17
//Calculate standard heat for given reaction
model Ex6_17

//C5H12+8O2---------->5CO2+6H2O Refer to book for the stoichiometry equation

//==============
//parameter section 
parameter Real HCO2(unit="kJ")=-393.8"standard heat of formation of CO2";
parameter Real HH2O(unit="kJ")=-242"standard heat of formation of H2O";
parameter Real HC5H12(unit="kJ")=-146.5"standard heat of formation of C5H12";
parameter Real HO2(unit="kJ")=0"standard heat of formation of O2";
parameter Real HC(unit="kJ")=0"standard heat of formation of C";
parameter Real HH2(unit="kJ")=0"standard heat of formation of H2";

//C5H12----->5C+6H2  eq 1
//5(C+O2)------>CO2)  eq 2
//6(H2+1/2O2----->H2O   eq 3
//C5H12+8O2----->5CO2+6H2O   eq 4

//================
//variable section
Real H1(unit="kJ")"heat of formation for reaction 1";
Real H2(unit="kJ")"heat of formation for reaction 2";
Real H3(unit="kJ")"heat of formation for reaction 3";
Real H4(unit="kJ")"heat of formation for original reaction ";

//==================
//equation section
equation
H1=(5*HC)+(6*HH2)-HC5H12;
H2=5*(HCO2-HC-HO2);
H3=6*(HH2O-(0.5*HO2)-HH2);
H4=(5*HCO2)+(6*HH2O)-(HC5H12)-(8*HO2);

end Ex6_17;
