//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:First law analysis of process
//Example:6.2
//Title:Applications of steady state flow process
//Determine exit velocity of steam
model Ex6_2

//================
//parameter section 
parameter Real Pi(unit="bar")=2"pressure of the superheated steam";
parameter Real Ti(unit="deg C")=300"temperature at which the steam enters";
parameter Real Pl(unit="bar")=0.2"Pressure at which the steam leaves";

//=========
//variable section
Real he(unit="kJ/kg")"enthalpy of the steam leaving";
Real hi(unit="kJ/kg")"enthalpy of the steam entering";
Real Ve(unit="m/s")"velocity of the steam leaving";

//===============
//equation section
equation
he=2609.9;//Refer to steam table in the appendix in book Pg no:443 for 0.2 bar and hg
hi=3072.1;//Refer to steam table in the appendix in book Pg no:445 for 2 bar and 300 deg C
Ve=sqrt(2*(hi-he)*1000);
end Ex6_2;
