model Ex6_20
//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:First law analysis of process
//chemically reacting systems
//Example:6.20
//Estimate standard heat for given reaction

//5H12+8O2---------->5CO2+6H2O Refer to book for the stoichiometry equation
//====================
//parameter section
parameter Real delH298(unit="kJ")=-3274.5"standard heat of reaction at 298 K";//calculated from example 6_17
parameter Real T1(unit="K")=298"initial standard heat temperature";
parameter Real T2(unit="K")=800"final temperature to calculate standard heat of formation";
parameter Real Cp1(unit="J/mol.K")=247"molar heat capacities of C5H12";
parameter Real Cp2(unit="J/mol.K")=33.62"molar heat capacities of O2";
parameter Real Cp3(unit="J/mol.K")=52.32"molar heat capacities of CO2";
parameter Real Cp4(unit="J/mol.K")=38.49"molar heat capacities of H2O";

//=================
//variable section
Real delCp(unit="J/mol.K")"total molar heat capacities";
Real delH800(unit="kJ")"standard heat of reaction at 800 K";

//================
//equation section
equation
delCp=(5*Cp3)+(6*Cp4)-Cp1-(8*Cp2);
delH800=delH298+((delCp*10^(-3))*(T2-T1));
end Ex6_20;
