//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:First law analysis of process
//Example:6.3
//Title:Applications of throttling
//Determine quality of steam in the mains

model Ex6_3

//===================
//parameter section
parameter Real P1(unit="bar")=10"pressure of the wet steam";
parameter Real P2(unit="bar")=1"pressure of the steam measured by the calorimeter";
parameter Real T2(unit="deg C")=110"temperature of the steam measured by the calorimeter";

//==========================
//variable section
Real hf(unit="kJ/kg")"enthalpy of the steam in liquid state";
Real hg(unit="kJ/kg")"enthalpy of the steam in vapour state";
Real he(unit="kJ/kg")"total enthalpy of the steam";
Real X(unit="dimensionless")"quality ofthe steam";

//================
//equation section
//Refer to steam tables in appendix for value of hf,hg,he and refer to book Pg no:154
equation
hf=762.61;
hg=2776.2;
he=2696.12;
he=(hg*X)+((1-X)*hf);//to find the quality of the steam
end Ex6_3;
