//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.11
//Title:Calculation of entropy change
//Calculate entropy change associated with fusion and vaporisation process
model Ex7_11

//================
//parameter secction
parameter Real hsf(unit="kJ/kg")=334.92"latent heat of fusion";
parameter Real hfg(unit="kJ/kg")=2256.94"latent heat of vaporization";
parameter Real T1(unit="del C")=0"Temperature at ice melts";
parameter Real T2(unit="del C")=100"Temperature at which water boils";

//================
//variable section
Real Ssf(unit="kJ/kg.K")"entropy change with the fusion processes";
Real Sfg(unit="kJ/kg.K")"entropy change with the vaporization processes";

//===============
//equations section
equation
Ssf=hsf/(T1+273);
Sfg=hfg/(T2+273);
end Ex7_11;
