//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.14
//Title:Calculation of entropy change
//Estimate change in entropy when partition is removed and gases allowed to mix
model Ex7_14

//=================
//parameter section
parameter Real P(unit="kPa")=100"pressure in both the compartments";
parameter Real T(unit="K")=300"Temperature in both the compartments";

//=================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//================
//variable section
Real YA(unit="dimensionless")"Mole fration of oxygen";
Real YB(unit="dimensionless")"Mole fraction of of nitrogen";
Real delSmix(unit="J/mol.K")"entropy change";

//===============
//equation section
equation
YA=1/2;
YB=1/2;
delSmix=-2*R*YA*log(YB);
//Remarks:delSmix is given as Rln 2 in book which value is 5.76
end Ex7_14;
