//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.15
//Title:Principle of entropy increase
//Calculate change in entropy of universe associated with the process
model Ex7_15

//================
//parameter section
parameter Real P(unit="bar")=2"Pressure of the superheated steam";
parameter Real T1(unit="deg C")=200"Temperature of the superheated steam";
parameter Real T2(unit="K")=300"Ambient temperature";

//================
//variable section
Real h1(unit="kJ/kg")"enthalpy of superheated steam";
Real s1(unit="kJ/kg.K")"entropy of superheated steam";
Real h2(unit="kJ/kg.K")"enthalpy of saturated liquid";
Real s2(unit="kJ/kg.K")"entropy of saturated liquid";
Real delSst(unit="kJ/kg.K")"change in entropy of steam";
Real q(unit="kJ")"change in enthalpy";
Real delSsr(unit="kJ/K")"entropy change in surrounding";
Real delSuni(unit="kJ/K")"entropy change in universe";

//===============
//equation section
equation
//Refer to steam table in the appendix book Pg no:444 for the value of h1,s1
h1=2870.5;
s1=7.5072;
h2=504.70;
s2=1.5301;
delSst=s2-s1;
q=h2-h1;
delSsr=(-q)/T2;
delSuni=delSst+delSsr;
end Ex7_15;
