//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.18
//Title:Second law analysis of a control volume
//Check the feasibility of the device
model Ex7_18

//=================
//parameter section
parameter Real n(unit="kmol/s")=2"number of moles of air";
parameter Real P1(unit="kPa")=250"Pressur at which the device takes in air";
parameter Real T1(unit="K")=350"Teperature at which the device takes in air";
parameter Real P2(unit="kPa")=100"Pressure of the hot stream";
parameter Real T2(unit="K")=450"Temperature of the hot stream";
parameter Real P3(unit="kPa")=100"Pressure of the cold stram";
parameter Real T3(unit="K")=250"Temperature of the cold stream";
parameter Real Cp(unit="J/mol.K")=7*R/2"Specific heat at constant pressure";

//================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//================
//variable section
Real delS(unit="kJ/K")"change in entropy";

//================
//equation section
equation
delS=(Cp*log((T2*T3)/(T1*T1)))-(R*log((P2*P3)/(P1*P1)));//change in entropy
//if delS value is greater than 0 then the device stisfies second law of thermodynamics
end Ex7_18;
