//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.20
//Title:Availability
//Determine maximum useful work per kg of steam 
model Ex7_20

//==================
//parameter section
parameter Real P1(unit="bar")=20"pressure of hte superheated steam";
parameter Real T1(unit="deg C")=300"Temperature of the superheated steam";
parameter Real P2(unit="bar")=1"pressure of the steam";
parameter Real T2(unit="deg C")=200"Temperature of the steam";
parameter Real PA(unit="bar")=1"Ambient Pressure";
parameter Real TA(unit="deg C")=25"Ambient temperature";

//================
//variable section
Real h1(unit="kJ/kg")"enthalpy in the first case";
Real h2(unit="kJ/kg")"enthalpy in the second case";
Real v1(unit="m^3/kg")"specific volume in the first case";
Real v2(unit="m^3/kg")"specific volume in the second case";
Real s1(unit="kJ/kg.K")"entropy in the first case";
Real s2(unit="kJ/kg.K")"entropy in the second case";
Real u1(unit="kJ/kg")"internal energy in the first case";
Real u2(unit="kJ/kg")"internal energy in the second case";
Real W(unit="kJ/kg")"maximum useful work per kg of steam";

//================
//equation section
equation
//Refer to steam table in the appendix and book Pg no:265 for the value of h1,h2,v1,v2,s1,s2
h1=3025.0;
v1=0.1255;
s1=6.7696;
h2=2875.4;//769.15
v2=2.1720;
s2=7.8349;
u1=((h1*1000)-(P1*10^5*v1))/1000;
u2=((h2*1000)-(P2*10^5*v2))/1000;
W=(u1+((10^5)*v1*(10^(-3)))-((TA+273)*s1))-(u2+((10^5)*v2*(10^(-3)))-((TA+273)*s2));
//Remarks:value of W is 228.609 but in the book value is given as 341.56 which is error
end Ex7_20;
